unit AboutForm;
{*******************************************************************************
  TCP/IP Chat Demo
  Written by David Clegg, davidclegg@optusnet.com.au.
*******************************************************************************}

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Resources;

type
  TAboutForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    pbLogo: System.Windows.Forms.PictureBox;
    label3: System.Windows.Forms.Label;
    label2: System.Windows.Forms.Label;
    lblComments: System.Windows.Forms.Label;
    lblBuild: System.Windows.Forms.Label;
    lblRelease: System.Windows.Forms.Label;
    lblVersion: System.Windows.Forms.Label;
    lblDescription: System.Windows.Forms.Label;
    btnClose: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TAboutForm_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    procedure PopulateControls;
  public
    constructor Create;
    class function ShowAboutForm: System.Windows.Forms.DialogResult;
  end;

implementation

uses
  System.Globalization, System.Diagnostics, SysUtils;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TAboutForm.InitializeComponent;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TAboutForm));
  Self.pbLogo := System.Windows.Forms.PictureBox.Create;
  Self.label3 := System.Windows.Forms.Label.Create;
  Self.label2 := System.Windows.Forms.Label.Create;
  Self.lblComments := System.Windows.Forms.Label.Create;
  Self.lblBuild := System.Windows.Forms.Label.Create;
  Self.lblRelease := System.Windows.Forms.Label.Create;
  Self.lblVersion := System.Windows.Forms.Label.Create;
  Self.lblDescription := System.Windows.Forms.Label.Create;
  Self.btnClose := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // pbLogo
  // 
  Self.pbLogo.Image := (System.Drawing.Image(resources.GetObject('pbLogo.Image')));
  Self.pbLogo.Location := System.Drawing.Point.Create(13, 11);
  Self.pbLogo.Name := 'pbLogo';
  Self.pbLogo.Size := System.Drawing.Size.Create(72, 72);
  Self.pbLogo.SizeMode := System.Windows.Forms.PictureBoxSizeMode.StretchImage;
  Self.pbLogo.TabIndex := 30;
  Self.pbLogo.TabStop := False;
  // 
  // label3
  // 
  Self.label3.Location := System.Drawing.Point.Create(13, 243);
  Self.label3.Name := 'label3';
  Self.label3.Size := System.Drawing.Size.Create(160, 16);
  Self.label3.TabIndex := 29;
  Self.label3.Text := 'davidclegg@optusnet.com.au';
  // 
  // label2
  // 
  Self.label2.Location := System.Drawing.Point.Create(13, 227);
  Self.label2.Name := 'label2';
  Self.label2.Size := System.Drawing.Size.Create(144, 16);
  Self.label2.TabIndex := 28;
  Self.label2.Text := 'Written by David Clegg';
  // 
  // lblComments
  // 
  Self.lblComments.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 8.25, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblComments.Location := System.Drawing.Point.Create(13, 99);
  Self.lblComments.Name := 'lblComments';
  Self.lblComments.Size := System.Drawing.Size.Create(264, 104);
  Self.lblComments.TabIndex := 27;
  Self.lblComments.Text := 'lblComments';
  // 
  // lblBuild
  // 
  Self.lblBuild.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 8.25, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblBuild.Location := System.Drawing.Point.Create(125, 67);
  Self.lblBuild.Name := 'lblBuild';
  Self.lblBuild.Size := System.Drawing.Size.Create(104, 16);
  Self.lblBuild.TabIndex := 26;
  Self.lblBuild.Text := 'lblBuild';
  // 
  // lblRelease
  // 
  Self.lblRelease.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 9.75, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblRelease.Location := System.Drawing.Point.Create(125, 51);
  Self.lblRelease.Name := 'lblRelease';
  Self.lblRelease.Size := System.Drawing.Size.Create(104, 14);
  Self.lblRelease.TabIndex := 25;
  Self.lblRelease.Text := 'lblRelease';
  // 
  // lblVersion
  // 
  Self.lblVersion.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 9.75, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblVersion.Location := System.Drawing.Point.Create(125, 27);
  Self.lblVersion.Name := 'lblVersion';
  Self.lblVersion.Size := System.Drawing.Size.Create(155, 14);
  Self.lblVersion.TabIndex := 24;
  Self.lblVersion.Text := 'lblVersion';
  // 
  // lblDescription
  // 
  Self.lblDescription.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 9.75, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblDescription.Location := System.Drawing.Point.Create(125, 11);
  Self.lblDescription.Name := 'lblDescription';
  Self.lblDescription.Size := System.Drawing.Size.Create(155, 14);
  Self.lblDescription.TabIndex := 23;
  Self.lblDescription.Text := 'lblDescription';
  // 
  // btnClose
  // 
  Self.btnClose.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.btnClose.Location := System.Drawing.Point.Create(205, 235);
  Self.btnClose.Name := 'btnClose';
  Self.btnClose.TabIndex := 22;
  Self.btnClose.Text := 'Close';
  // 
  // TAboutForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(292, 270);
  Self.Controls.Add(Self.pbLogo);
  Self.Controls.Add(Self.label3);
  Self.Controls.Add(Self.label2);
  Self.Controls.Add(Self.lblComments);
  Self.Controls.Add(Self.lblBuild);
  Self.Controls.Add(Self.lblRelease);
  Self.Controls.Add(Self.lblVersion);
  Self.Controls.Add(Self.lblDescription);
  Self.Controls.Add(Self.btnClose);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TAboutForm';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'About...';
  Include(Self.Load, Self.TAboutForm_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TAboutForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TAboutForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

class function TAboutForm.ShowAboutForm: System.Windows.Forms.DialogResult;
begin
  with TAboutForm.Create do
    Result := ShowDialog;
end;

procedure TAboutForm.TAboutForm_Load(sender: System.Object; e: System.EventArgs);
begin
  PopulateControls;
end;

procedure TAboutForm.PopulateControls;
var
  lFileVersionInfo: FileVersionInfo;
begin
  //Show version information
  lFileVersionInfo := FileVersionInfo.GetVersionInfo(Application.ExecutablePath);
  lblDescription.Text := lFileVersionInfo.FileDescription;
  lblVersion.Text := Format('Version %s.%s',
    [lFileVersionInfo.ProductMajorPart, lFileVersionInfo.ProductMinorPart]);
  lblRelease.Text := Format('Release %s', [lFileVersionInfo.ProductBuildPart]);
  lblBuild.Text := Format('Build %s', [lFileVersionInfo.ProductPrivatePart]);
  lblComments.Text := lFileVersionInfo.Comments;

  //Make the bitmap transparent
  Bitmap(pbLogo.Image).MakeTransparent;
end;

end.
